#include-once
#Include <Array.au3>
#include <Date.au3>


    Global Const $never = "9999/12/31"          ; date de "fin du monde" = jamais

    Global $_dates_fetes                ; la table des dates de ftes pour l'anne traite
    Global $_annee_fetes                ; anne pour laquelle les dates de ftes mobiles sont actuellement calcules
	Global $dtDebut, $dtFin, $delta, $vj
	Global $ferie, $dimanche, $samedi, $autre
	Global $delta1 , $delta2 , $delta3 , $delta4

    ; Renvoie le nombre de jours ouvrs entre deux dates exprimes sous forme AAAA/MM/JJ
    ;
    ; Ce calcul tient compte des dimanches et jours fris (y compris les ftes mobiles) et
    ; des variations "politiques", par exemple la gestion  gomtrie variable du lundi de
    ; Pentecte en France.
    Func _NbJoursOuvres($dtDebut, $dtFin)
        Local $d1, $dow, $date, $delta
        If $dtDebut = $dtFin Then
            Return(0)
        EndIf
        If $dtDebut > $dtFin Then
            $date = $dtFin
            $dtFin = $dtDebut
        Else
            $date = $dtDebut
        EndIf
		$date = _DateAdd('D', -1, $date);tient compte du premier jour
        $d1 = StringSplit($date, '/-')
        $dow = _DateToDayOfWeekISO($d1[1], $d1[2], $d1[3])  ; ISO Week day number for a given date 0=Monday - 6=Sunday
        $delta = 0
		$delta1 = 0
		$delta2 = 0
		$delta3 = 0
		$delta4 = 0
        While $date < $dtFin
			$pos = 0;indique si jour repr pour viter doublon avec fri
			$delta = $delta + 1;incrmente le nb de jours
			$date = _DateAdd('D', 1, $date)                 ; date + 1
            $dow += 1                                       ; jour de la semaine + 1
            $d1 = StringLeft($date, 4)                      ; on vrifie s'il y a changement d'anne
            If $_annee_fetes <> $d1 Then                    ; si oui, on calcule les ftes mobiles de la nouvelle anne
                $_annee_fetes = $d1
                _DateFetesMobiles($_annee_fetes)
            EndIf
			        $d1 = StringSplit($date, '/')
					$dow =_DateToDayOfWeek($d1[1], $d1[2], $d1[3])
            If $autre > "" Then
				If $dow = $vj Then;;
					$delta1 += 1                                 ; c'est un jour du combo
					$pos = 1
				EndIf
			EndIf

            If $dimanche = 1 Then
				If $dow = 1 Then;  si   dimanche
					$delta3 += 1
					$pos = 1
				EndIf
			EndIf
            If $samedi = 1 Then
				If $dow = 7 Then;  si samedi
					$delta4 += 1
					$pos = 1
				EndIf
			EndIf
			If $ferie = 1 Then
				If  _ArrayBinarySearch($_dates_fetes, $date) <> -1 And $pos = 0 Then     ;; si  jour fri
					$delta2 += 1       ;si $pos = 1 le jour est compt par les autres procdures
				EndIf					;si $pos = 0 le jour fri n'est pas en doublon
			EndIf
		WEnd

		Global $delta = $delta - ($delta1 + $delta2 + $delta3 + $delta4)
			;nb de jours total moins les jours dduits qui sont choisis

    EndFunc



    ; ajoute ou retranche N jours ouvrs  une date exprime sous forme AAAA/MM/JJ
    Func _JoursOuvresPlusN($date, $jours)
        Local $d1, $dow, $direct

        Select
            Case $jours > 0
                $direct = 1
            Case $jours < 0
                $direct = -1
            Case Else
                Return($date)
        EndSelect
        $jours = Abs($jours)
        $d1 = StringSplit($date, '/-')
        $dow = _DateToDayOfWeekISO($d1[1], $d1[2], $d1[3]) - 1
        Do
            $date = _DateAdd('D', $direct, $date)           ; date +/- 1
            $dow += $direct                                 ; jour de la semaine +/- 1
            If $dow < 0 Then $dow += 7
            $d1 = StringLeft($date, 4)                      ; on vrifie s'il y a changement d'anne
            If $_annee_fetes <> $d1 Then                    ; si oui, on calcule les ftes mobiles de la nouvelle anne
                $_annee_fetes = $d1
                _DateFetesMobiles($_annee_fetes)
            EndIf
            If Mod($dow, 7) <> 6 And _ArrayBinarySearch($_dates_fetes, $date) = -1 Then     ;; si pas dimanche ni jour fri
                $jours -= 1                                 ; c'est un jour ouvr, donc on le dcompte
            EndIf
        Until $jours = 0
        Return($date)
    EndFunc



    ; calcule la date de Pques AAAA/MM/JJ pour l'anne passe en paramtre, numrique ou string au format AA ou AAAA
    Func _EasterDate($y)
        Local $_y, $_g, $_s, $_x, $_z, $_d, $_e, $_n, $_j, $_m

        $_y = Int(Number($y))
        If $_y <= 99 And $_y >= 0 Then
            $_y += 2000
        EndIf
        If $_y < 1592 Then
            Return(SetError(1, 0, ""))
        EndIf
        $_g = Mod($_y, 19) + 1
        $_s = Int($_y / 100) + 1
        $_x = Int(3 * $_s / 4) - 12
        $_z = Int((8 * $_s + 5) / 25) - 5
        $_d = Int(5 * $_y / 4) - $_x - 10
        $_e = Mod(11 * $_g + 20 + $_z - $_x, 30)
        If ($_e = 25 And $_g > 11) Or $_e = 24 Then
            $_e += 1
        EndIf
        $_n = 44 - $_e
        If $_n < 21 Then
            $_n += 30
        EndIf
        $_j = $_n + 7 - Mod($_d + $_n, 7)
        If $_j > 31 Then
            $_j -= 31
            $_m = 4
        Else
            $_m = 3
        EndIf

        Return(StringFormat("%04i/%02i/%02i", $_y, $_m, $_j))
    EndFunc



    ;; Met  jour la table des jours fris mobiles en fonction de l'anne
    Func _DateFetesMobiles($y)
        Local $_d
        Local Const $fetesConst[21] = [ _   ;********** ftes mobiles calcules au vol
            "", _                   ; lundi de Pques ;        index 0 (ne pas dplacer)
            "", _                   ; Ascension ;           index 1 (ne pas dplacer)
            "", _                   ; lundi de Pentecte ; index 2 (ne pas dplacer) voir notes
            "", _                   ; les 10 entres qui suivent peuvent tre employes pour des besoins spcifiques
            "", _
            "", _
            "", _
            "", _
            "", _
            "", _
            "", _
            "", _
            "", _                   ;********** ftes fixes
            $y & "/01/01", _        ; Jour de l'an
            $y & "/05/01", _        ; Fte du travail
            $y & "/05/08", _        ; Fte de la Victoire 1945
            $y & "/07/14", _        ; Fte Nationale
            $y & "/08/15", _        ; Assomption
            $y & "/11/01", _        ; Toussaint
            $y & "/11/11", _        ; Armistice 1918
            $y & "/12/25"]          ; Nol

        $_d = _EasterDate($y)
        $_dates_fetes = $fetesConst
        $_dates_fetes[0] = _DateAdd('d', 1, $_d)    ;; lundi de Pques
        $_dates_fetes[1] = _DateAdd('d', 39, $_d)   ;; Ascension
        If ($y < "2005") Or ($y > "2007") Then
            $_dates_fetes[2] = _DateAdd('d', 50, $_d)   ;; lundi de Pentecte, sauf quand il a t dcrt non fri ... Pffft !
        EndIf
        $_dates_fetes = _ArrayUnique($_dates_fetes, 1)  ;; ddoublonnement. L'index [0] contient la dimension (ce qui est un choix dbile)
        _ArraySort($_dates_fetes, 1)                    ;; tri descendant : les dates "surnagent" ;-)
        ReDim $_dates_fetes[_ArraySearch($_dates_fetes, "") - 1]    ;; on enlve "" et la dimension, valeurs parasites
        _ArrayReverse($_dates_fetes)
		;_ArrayDisplay($_dates_fetes)
    EndFunc
